import { BlockVolume } from "@minecraft/server";
export class Vec3 {
  constructor(x, y, z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }
  add(vec3) {
    return new Vec3(this.x + vec3.x, this.y + vec3.y, this.z + vec3.z);
  }
  static fromMinecraftVector3(vec3) {
    return new Vec3(vec3.x, vec3.y, vec3.z);
  }
  toBlockVolume(range, verticalRange = range) {
    return new BlockVolume(
      new Vec3(this.x - range, this.y - verticalRange, this.z - range),
      new Vec3(this.x + range, this.y + verticalRange, this.z + range)
    );
  }
  static add(v1, v2) {
    return new Vec3(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
  }
  rotateY(yRotation) {
    const radians = yRotation * (Math.PI / 180);
    const cos = Math.cos(radians);
    const sin = Math.sin(radians);
    return new Vec3(this.x * cos - this.z * sin, this.y, this.x * sin + this.z * cos);
  }
  static compareVector3(v1, v2) {
    return v1.x === v2.x && v1.y === v2.y && v1.z === v2.z;
  }
  static stringifyVector3(v, includeCommas = false) {
    const c = includeCommas ? ',' : '';
    return `${v.x}${c} ${v.y}${c} ${v.z}`;
  }
}